<?php
declare(strict_types = 1);
if (file_exists("config.php")) {
  require_once "config.php";
} else {
  if (!defined("admins")) {
    define("admins", [admins[0]]);
  }
}
if (!is_dir("bots")) {
  mkdir("bots");
}
if (phpversion() <= 8) {
  die("Php Version +8 Reuiqre");
}
ini_set("memory_limit", -1);
ini_set("max_execution_time", -1);
date_default_timezone_set("Asia/Tehran");
if (!\file_exists("madeline.php")) {
  \copy("https://phar.madelineproto.xyz/madeline.php", "madeline.php");
}
require_once "jdf.php";
require_once "madeline.php";
use danog\MadelineProto\API;
use danog\MadelineProto\MTProto;
use danog\MadelineProto\EventHandler;
use danog\MadelineProto\Exception;
use Amp\Loop;
use danog\MadelineProto\Settings\Database\Redis;
use danog\MadelineProto\ParseMode;
use Amp\Mysql;
use danog\MadelineProto\EventHandler\Attributes\Cron;
use Amp\ByteStream;
use danog\MadelineProto\EventHandler\Attributes\Handler;
use danog\MadelineProto\EventHandler\Filter\FilterCommand;
use danog\MadelineProto\EventHandler\Message\GroupMessage;
use danog\MadelineProto\EventHandler\Filter\FilterRegex;
use danog\MadelineProto\EventHandler\Filter\FilterText;
use danog\MadelineProto\EventHandler\Filter\FilterTextCaseInsensitive;
use danog\MadelineProto\EventHandler\Message\PrivateMessage;
use danog\MadelineProto\EventHandler\Message;
use danog\MadelineProto\EventHandler\Message\ChannelMessage;
use danog\MadelineProto\EventHandler\SimpleFilter\FromAdmin;
use danog\MadelineProto\EventHandler\SimpleFilter\Incoming;
use danog\MadelineProto\SimpleEventHandler;
use Amp\Process\Process;
use Revolt\EventLoop;
use danog\MadelineProto\Logger;
use danog\MadelineProto\Settings;
use danog\MadelineProto\Settings\AppInfo;
use danog\MadelineProto\Settings\Peer;
use danog\MadelineProto\Settings\Serialization;
use danog\MadelineProto\RPCErrorException;
use danog\Loop\GenericLoop;
class MrPoKeR extends SimpleEventHandler
{
  private $manager = [];
  private $accounts = [];
  private $admins = [];
  public function __sleep(): array
  {
    return ["manager",
      "accounts",
      "admins"];
  }
  public function getAaccounts() {
    return $this->accounts;
  }
  public function setAccounts($array) {
    $this->accounts = $array;
  }
  private function isSuperGroup($id) {
    if (str_split((string) $id, 4)[0] == -100) {
      return true;
    }
    return false;
  }
  public function changeManager($array) {
    $this->manager[$session] = $array;
  }
  public function getManager($index, $session) {
    $m = $this->manager[$session];
    return $m[$index] ?? $this->manager[$session];
  }
  #[Cron(period: 60)]
  public function cron1(): void
  {
    $session = explode("/", $this->getSessionName());
    $c = count($session) - 1;
    $session = str_replace("Harim", "", $session[$c]);
    $fonts = [
      ["Ѳ",
        "１",
        "❷",
        "➂",
        "４",
        "５",
        "６",
        "７",
        "８",
        "❾"],
      [
        "【0】",
        "【1】",
        "【2】",
        "【3】",
        "【4】",
        "【5】",
        "【6】",
        "【7】",
        "【8】",
        "【9】",
      ],
      [
        "『0』",
        "『1』",
        "『2』",
        "『3』",
        "『4』",
        "『5』",
        "『6』",
        "『7』",
        "『8』",
        "『9』",
      ],
      ["░0",
        "░1",
        "░2",
        "░3",
        "░4",
        "░5",
        "░6",
        "░7",
        "░8",
        "░9"],
      [
        "[̲̅0⃣]",
        "[̲̅1⃣]",
        "[̲̅2⃣]",
        "[̲̅3⃣]",
        "[̲̅4⃣]",
        "[̲̅5⃣]",
        "[̲̅6⃣]",
        "[̲̅7⃣]",
        "[̲̅8⃣]",
        "[̲̅9⃣]",
      ],
      ["0",
        "҉1",
        "҉2",
        "҉3",
        "҉4",
        "҉5",
        "҉6",
        "҉7",
        "҉8",
        "҉9҉"],
      ["░0",
        "░۱",
        "░۲",
        "░۳",
        "░۴",
        "░۵",
        "░۶",
        "░۷",
        "░۸",
        "░۹"],
      ["0",
        "❶",
        "❷",
        "❸",
        "❹",
        "❺",
        "❻",
        "❼",
        "❽",
        "❾"],

      ["⁰",
        "¹",
        "²",
        "'³",
        "'⁴",
        "⁵",
        "⁶",
        "⁷",
        "'⁸",
        "⁹"],
    ];
    $time2 = str_replace(
      range(0, 9),
      $fonts[array_rand($fonts)],
      date("H:i")
    );
    if ($this->accounts[$session]["name"] == "on") {
      $this->account->updateProfile(last_name: "$time2");
    }
    if ($this->accounts[$session]["bio"] == "on") {
      $this->account->updateProfile(
        about: "𖤍𖤓 $time2 " .
        jdate("l", time()) .
        " ♡ " .
        jdate("Y/m/d", time())
      );
    }
  }
  #[Cron(period: 1)]
  public function cron2(): void
  {
    $session = explode("/", $this->getSessionName());
    $c = count($session) - 1;
    $session = str_replace("Harim", "", $session[$c]);
    if (
      $this->accounts[$session]["flood"] == "on" &&
      time() >= $this->accounts[$session]["floodTime"]
    ) {
      $this->accounts[$session]["stats"] = "on";
      $this->accounts[$session]["flood"] = "off";
      $this->accounts[$session]["floodTime"] = 0;
    }

    if (time() >= $this->accounts[$session]["timeon"]) {
      $time = $this->accounts[$session]["timer"];
      $sd = strtotime($time . " minutes");
      $this->accounts[$session]["timeon"] = $sd;
      if ($this->accounts[$session]["spm"] == "off") {
        $this->accounts[$session]["spm"] = "on";
      } else {
        $getacc = [];
        foreach ($this->accounts as $key => $value) {
          if ($value["flood"] == "off") {
            $getacc[] = $this->accounts[$key];
          }
        }
        if (!empty($getacc)) {
          $getacc = $getacc[array_rand($getacc)];
          $this->accounts[$getacc["sessionName"]]["stats"] = "on";
          $time = $this->accounts[$getacc["sessionName"]]["timer"];
          $sd2 = strtotime("$time minutes");
          $this->accounts[$getacc["sessionName"]]["timeon"] = $sd;
          $this->accounts[$getacc["sessionName"]]["spm"] = "on";
        }
        $this->accounts[$session]["spm"] = "off";
      }
    }
  }

  #[Cron(period: 5)]
  public function cron5(): void
  {
    $session = explode("/",
      $this->getSessionName());
    $c = count($session) - 1;
    $session = str_replace("Harim",
      "",
      $session[$c]);
    if ($this->manager[$session]['timer']['stats'] == "on" && !empty($this->manager[$session]['timer']['text']) && !empty($this->manager[$session]['timer']['id'])) {
      $day = 100 * $this->manager[$session]['timer']['day'];
      for ($i = 1; $i <= $day; $i++) {
        try {
          $time = $this->manager[$session]['lastsent'] == 0 ? strtotime(($this->manager[$session]['timer']['time'] * $i).' minutes', time()) : ($this->manager[$session]['lastsent'] + ($this->manager[$session]['timer']['time'] * 60));

          $res = $this->sendMessage(peer: $this->manager[$session]['timer']['id'], message: $this->manager[$session]['timer']['text'], scheduleDate: $time);
          $this->manager[$session]['lastsent'] = isset($res->date) ? $res->date : $time;
          $this->sleep(1);
        }catch(\Throwable $e) {
          break;
        }
      }
    }
  }
  public function onStart() {
    try {
      $this->channels->joinChannel(channel: "@epsilontech");
    } catch (\Throwable $e) {
      unset($e);
    }
    $session = explode("/", $this->getSessionName());
    $c = count($session) - 1;
    $session = str_replace("Harim", "", $session[$c]);
    if (!isset($this->accounts[$session])) {
      $this->accounts[$session]["stats"] = "off";
      $this->manager[$session]["timer"]['text'] = '';
      $this->manager[$session]["timer"]['id'] = "";
      $this->manager[$session]["timer"]['day'] = 2;
      $this->manager[$session]["timer"]['time'] = 5;
      $this->manager[$session]['lastsent'] = 0;
      $this->accounts[$session]["bio"] = "off";
      $this->accounts[$session]["name"] = "off";
      $this->accounts[$session]["typing"] = "off";
      $this->accounts[$session]["reply"] = "off";
      $this->accounts[$session]["repspam"] = [];
      $this->accounts[$session]["flood"] = "off";
      $this->accounts[$session]["floodTime"] = 0;
      $this->accounts[$session]["timeon"] = 0;
      $this->accounts[$session]["onlymessage"] = "off";
      $this->accounts[$session]["timer"] = rand(3, 12);
      $this->accounts[$session]["spm"] = "off";
      $this->accounts[$session]["timerz"] = "on";
      $this->accounts[$session]["sessionName"] = $session;
    }
    if (empty($this->manager[$session]["foshlist"])) {
      $this->manager[$session]["gp"] = "";
      $this->manager[$session]["gps"] = "";
      $this->manager[$session]["enemylist"] = [];
      $this->manager[$session]["foshlist"] = [];
      $this->manager[$session]["pText"] = "خان زاده حریمم👌😶";
      $this->manager[$session]["mens"] = [];
      $this->manager[$session]["step"] = "";
      $this->manager[$session]["delall"] = "";
      $this->manager[$session]["spamtime"] = 2;
      $this->manager[$session]["spampv"] = 0;
    }
    $q = $this;
    $Loop = new GenericLoop(function () use ($q, $session) {
      $spm = $q->accounts[$session]["spm"];
      $timerz = $q->accounts[$session]["timerz"];
      $g = $q->getManager("gp", $session);
      $f = $q->getManager("foshlist", $session);
      $time = $q->getManager("spamtime", $session);
      if ($q->accounts[$session]["stats"] == "on") {
        try {
          if (!empty($f) && ($spm == "on" or $timerz == "off")) {
            $me = $q->getManager("mens", $session);
            $pt = $q->getManager("pText", $session);
            $spv = $q->getManager("spampv", $session);
            if (!empty($q->accounts[$session]["repspam"])) {
              foreach ($q->accounts[$session]["repspam"] as $key => $value) {
                if (empty($q->accounts[$session]["repspam"][$key])) {
                  continue;
                }
                foreach (
                  $q->accounts[$session]["repspam"][$key]
                  as $key2 => $value2
                ) {
                  if (!is_int($value2) or $key2 == 0) {
                    continue;
                  }
                  $ge = $q->getmsg($key, $value2);
                  if (!isset($ge["messages"][0]["_"])) {
                    continue;
                  }
                  if ($ge["messages"][0]["_"] == "messageEmpty") {
                    $q->accounts[$session]["repspam"][$key][$key2] = "none";
                    continue;
                  }
                  $inputReplyToMessage = ['_' => 'inputReplyToMessage',
                    'reply_to_msg_id' => $value2];
                  $q->messages->sendMessage(
                    peer: $key,
                    message: $pt . PHP_EOL . "•" . $f[array_rand($f)] . "•",
                    reply_to: $inputReplyToMessage,
                  );
                }
              }
            }
            if ($spv != 0) {
              $q->messages->sendMessage(
                peer: $spv,
                message: $pt . PHP_EOL . "•" . $f[array_rand($f)] . "•"
              );
            }
            if (!empty($g) && $g[0] == "-") {
              $tags = "";
              if (!empty($me)) {
                array_map(function ($id) use (&$tags) {
                  $tags .= "[𖤍](tg://user?id=$id)-";
                }, $me);
              }
              $q->messages->sendMessage(
                peer: $g,
                message: $pt .
                PHP_EOL .
                "•" .
                $f[array_rand($f)] .
                "•" .
                PHP_EOL .
                $tags,
                parse_mode: "MarkDown"
              );
            }
          }
        } catch (\danog\MadelineProto\RPCError\FloodWaitError $e) {
          $q->accounts[$session]["stats"] = "off";
          $q->accounts[$session]["flood"] = "on";
          $q->accounts[$session]["floodTime"] = strtotime(
            $e->getWaitTime() . " seconds",
            time()
          );
          $getacc = [];
          foreach ($q->accounts as $key => $value) {
            if ($value["flood"] == "off") {
              $getacc[] = $this->accounts[$key];
            }
          }
          if (!empty($getacc)) {
            $getacc = $getacc[array_rand($getacc)];
            $q->accounts[$getacc["sessionName"]]["stats"] = "on";
          }
        }
      }
      return (int) $time ?? 2;
    },
      "Timerhjs");
    $Loop->start();
  }
  private function get_rams() {
    return memory_get_usage(true);
  }
  private function get_server_memory_usage() {
    $proc = Process::start("free");
    $free = ByteStream\buffer($proc->getStdout());
    $proc->join();
    $free = (string) trim($free);
    $free_arr = explode("\n",
      $free);
    $mem = explode(" ",
      $free_arr[1]);
    $mem = array_filter($mem);
    $mem = array_merge($mem);
    $memory_usage = ($mem[2] / $mem[1]) * 100;
    return $memory_usage;
  }

  private function get_server_cpu_usage() {
    $load = sys_getloadavg();
    return $load[0];
  }
  public function getmsg($chat_id,
    $id) {
    if (!$this->isSuperGroup($chat_id)) {
      $m = $this->messages->getMessages(peer: $chat_id, id: [$id]);
      return $m;
      unset($m);
    }
    $m = $this->channels->getMessages(channel: $chat_id, id: [$id]);
    return $m;
    unset($m);
  }
  private function isJson($string) {
    json_decode($string);
    return json_last_error() === JSON_ERROR_NONE;
  }
  public function getReportPeers() {
    return ["@epsilontech_support"];
  }
  private function toReal($seconds) {
    $zero = new DateTime("@0");
    $offset = new DateTime("@$seconds");
    $diff = $zero->diff($offset);
    return sprintf(
      "%02d:%02d:%02d",
      $diff->days * 24 + $diff->h,
      $diff->i,
      $diff->s
    );
  }
  private function forExec($array) {
    $a = [];
    if (empty($array) or is_null($array)) {
      return $a;
    }
    foreach ($array as $key => $value) {
      //   $a[$key[0] == ":" ? $key : ":".$key] = $value;
      $a[$key] = $value;
    }
    return $a;
  }
  function getallchats($ty = "chats") {
    $dia = $this->getDialogs();
    $list = [];
    foreach ($dia as $id) {
      try {
        $type = $this->getInfo($id);
        if ($ty == "chats") {
          if (
            isset($type["type"]) &&
            ($type["type"] == "supergroup" or $type["type"] == "chat")
          ) {
            $list[] = $type["bot_api_id"];
          }
        } elseif ($ty == "users") {
          if (isset($type["type"]) && $type["type"] == "user") {
            $list[] = $type["bot_api_id"];
          }
        } else {
          if (isset($type["type"]) && $type["type"] == "channel") {
            $list[] = $type["bot_api_id"];
          }
        }
      } catch (\Throwable $e) {
        unset($e);
        continue;
      }
    }
    return $list;
  }
  public function getidbyuser($id) {
    try {
      $get = $this->getFullInfo($id);
      if (isset($get["User"]["id"])) {
        return $get["User"]["id"];
      }
      return "❎ERROR Id";
    } catch (\Throwable $e) {
      return $e->getMessage();
    }
  }
  #[Handler]
  public function handleMessage((Incoming & PrivateMessage) | (Incoming & GroupMessage) $bot): void
  {
    try {
      $message = $bot->message;
      $session = explode("/",
        $this->getSessionName());
      $c = count($session) - 1;
      $session = str_replace("Harim", "", $session[$c]);
      $peer = $bot->chatId;
      $from_id = $bot->senderId;
      $mid = $bot->id;
      if ($bot instanceof GroupMessage) {
        if (!isset($this->accounts[$session]["repspam"][$peer])) {
          $this->accounts[$session]["repspam"][$peer] = [];
        }
        if (
          isset($this->accounts[$session]["repspam"][$peer][$from_id]) &&
          $this->accounts[$session]["repspam"][$peer][$from_id] == "none"
        ) {
          $this->accounts[$session]["repspam"][$peer][$from_id] = $mid;
        }
        if (in_array($from_id, admins) or in_array($from_id, $this->admins)) {
          if (preg_match("/^setrep$/", $message, $m)) {
            if ($bot->isReply()) {
              $getmsg = $bot->getReply();
              if (isset($getmsg->senderId)) {
                $id = $getmsg->senderId;
                if (isset($this->accounts[$session]["repspam"][$peer][$id])) {
                  $bot->reply(message:" لیست وجود داشته");
                  return;
                }
                $this->accounts[$session]["repspam"][$peer][$id] =
                $getmsg->id;
                $bot->reply(message:"کاربر با موفقیت به لیست اسپم افزوده شد");
                return;
              } else {
                $bot->reply(message: "Error Reply");
                return;
              }
            }
          }



          if (preg_match("/^delrep[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
            $id;
            if (empty($m[1])) {
              if ($bot->isReply()) {
                $getmsg = $bot->getReply();
                if (isset($getmsg->senderId)) {
                  $id = $getmsg->senderId;
                } else {
                  $bot->reply(message: "Error Reply");
                  return;
                }
              }
            } else {
              $get = $this->getidbyuser($m[1]);
              if (!is_numeric($get)) {
                $bot->reply(message: $get);
                return;
              }
              $id = $get;
            }
            if (isset($this->accounts[$session]["repspam"][$peer][$id])) {
              unset($this->accounts[$session]["repspam"][$peer][$id]);
              $bot->reply(message:"کاربر با موفقیت حذف شد");
              return;
            }
            $bot->reply(message: "در لیست وجود ندارد");
            return;
          }
          if ($message == "cleanreplist") {
            if (!isset($this->accounts[$session]["repspam"][$peer])) {
              $bot->reply(
                message: "گروه در لیست وجود ندارد مجدد تلاش کنید"
              );
              return;
            }
            $this->accounts[$session]["repspam"][$peer] = [];
            $bot->reply(message: "لیست ریپلی با موفقیت پاک شد");
            return;
          }
          if ($message == "replist") {
            if (!isset($this->accounts[$session]["repspam"][$peer])) {
              $bot->reply(
                message: "گروه در لیست وجود ندارد مجدد تلاش کنید");
              return;
            }
            if (empty($this->accounts[$session]["repspam"][$peer])) {
              $bot->reply(message: "لیست ریپلی خالی میباشد");
              return;
            }
            $list = "";
            foreach (
              $this->accounts[$session]["repspam"][$peer]
              as $key => $value
            ) {
              $list .= $key . " -> " . $value . "\n";
            }
            $bot->reply(message: $list);
            return;
          }

          if (preg_match("/^mute[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
            try {
              if (!$this->isSuperGroup($peer)) {
                return;
              }
              $id = "";
              if (empty($m[1])) {
                if ($bot->isReply()) {
                  $getmsg = $bot->getReply();
                  if (isset($getmsg->senderId)) {
                    $id = $getmsg->senderId;
                  } else {
                    $bot->reply(message:"Error Replay");
                    return;
                  }
                }
              } else {
                $get = $this->getidbyuser($m[1]);
                if (!is_numeric($get)) {
                  $bot->reply(message: $get);
                  return;
                }
                $id = $get;
              }
              $chatBannedRights = [
                "_" => "chatBannedRights",
                "view_messages" => false,
                "send_messages" => true,
                "send_media" => true,
                "send_stickers" => true,
                "send_gifs" => true,
                "send_games" => true,
                "send_inline" => true,
                "embed_links" => true,
                "send_polls" => true,
                "change_info" => true,
                "invite_users" => true,
                "pin_messages" => true,
                "until_date" => 0,
              ];
              $this->channels->editBanned([
                "channel" => $peer,
                "participant" => $id,
                "banned_rights" => $chatBannedRights,
              ]);
              $bot->reply(message: "کاربر با موفقیت به لیست سکوت افزوده شد");
              return;
            } catch (\Throwable $e) {
              $bot->reply(message: $e->getMessage());
              return;
            }
          }
          if (preg_match("/^unmute[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
            try {
              if (!$this->isSuperGroup($peer)) {
                return;
              }
              $id = "";
              if (empty($m[1])) {
                if ($bot->isReply()) {
                  $getmsg = $bot->getReply();
                  if (isset($getmsg->senderId)) {
                    $id = $getmsg->senderId;
                  } else {
                    $bot->reply(message: "Reply Error");
                    return;
                  }
                }
              } else {
                $get = $this->getidbyuser($m[1]);
                if (!is_numeric($get)) {
                  $bot->reply(message: $get);
                  return;
                }
                $id = $get;
              }
              $chatBannedRights = [
                "_" => "chatBannedRights",
                "view_messages" => false,
                "send_messages" => false,
                "send_media" => false,
                "send_stickers" => false,
                "send_gifs" => false,
                "send_games" => false,
                "send_inline" => false,
                "embed_links" => false,
                "send_polls" => false,
                "change_info" => true,
                "invite_users" => false,
                "pin_messages" => true,
                "until_date" => 0,
              ];
              $this->channels->editBanned([
                "channel" => $peer,
                "participant" => $id,
                "banned_rights" => $chatBannedRights,
              ]);
              $bot->reply(message: "کاربر با موفقیت از لیست سکوت حذف شد");
              return;
            } catch (\Throwable $e) {
              $bot->reply(message: $e->getMessage());
              return;
            }
          }
          if (preg_match("/^lockgp/", $message)) {
            try {
              $chatBannedRights = [
                "_" => "chatBannedRights",
                "view_messages" => false,
                "send_messages" => true,
                "send_media" => true,
                "send_stickers" => true,
                "send_gifs" => true,
                "send_games" => true,
                "send_inline" => true,
                "embed_links" => true,
                "send_polls" => true,
                "change_info" => true,
                "invite_users" => true,
                "pin_messages" => true,
                "until_date" => 0,
              ];
              $this->messages->editChatDefaultBannedRights([
                "peer" => $peer,
                "banned_rights" => $chatBannedRights,
              ]);
              $bot->reply(message:"گروه با موفقیت قفل شد ");
              return;
            } catch (\Throwable $e) {
              $bot->reply(message: $e->getMessage());
              return;
            }
          }
          if (preg_match("/^unlockgp/", $message)) {
            try {
              $chatBannedRights = [
                "_" => "chatBannedRights",
                "view_messages" => false,
                "send_messages" => false,
                "send_media" => false,
                "send_stickers" => false,
                "send_gifs" => false,
                "send_games" => false,
                "send_inline" => false,
                "embed_links" => false,
                "send_polls" => false,
                "change_info" => true,
                "invite_users" => false,
                "pin_messages" => true,
                "until_date" => 0,
              ];
              $this->messages->editChatDefaultBannedRights([
                "peer" => $peer,
                "banned_rights" => $chatBannedRights,
              ]);
              $bot->reply(message: "گروه با موفقیت باز شد");
              return;
            } catch (\Throwable $e) {
              $bot->reply(message: $e->getMessage());
              return;
            }
          }
          if (preg_match("/^(tag|تگ)$/u", $message, $match)) {
            if (!$this->isSuperGroup($peer)) {
              $bot->reply(message: "این دستور فقط برای سوپرگروه است");
              return;
            }
            $result = [];
            $offset = 0;
            $mentioned = 0;
            while (true) {
              $participants = $this->channels->getParticipants([
                "channel" => $peer,
                "filter" => ["_" => "channelParticipantsRecent"],
                "offset" => $offset,
                "limit" => 200,
              ]);
              foreach ($participants["users"] as $member) {
                if (!$member["deleted"] && !$member["bot"]) {
                  $result[] = "[{$member["first_name"]}](mention:{$member["id"]})";
                  $mentioned++;
                }
              }

              $count = count($participants["users"]);
              $offset += $count;

              if ($count === 0) {
                break;
              }
              if ($mentioned >= 40) {
                break;
              }
            }
            $chunk = array_chunk($result, 10);
            foreach ($chunk as $mentionGroup) {
              $this->sendMessage(message: "خان زاده حریمم بالا باشید😶👌\n" . implode("\n", $mentionGroup), peer: $peer, parseMode: ParseMode::MARKDOWN);
            }
          }
          if ($message == "leave") {
            if (!$this->isSuperGroup($peer)) {
              $bot->reply(message: "این دستور فقط برای سوپرگروه است");
              return;
            }
            try {
              $this->channels->leaveChannel(["channel" => $peer]);
              return;
            } catch (\Throwable $e) {
              $bot->reply(message: $e->getMessage());
              return;
            }
          }
        }
        ///end instanceof
      }

      if ($this->accounts[$session]["flood"] == "on" &&
        time() >= $this->accounts[$session]["floodTime"]) {

        $this->accounts[$session]["stats"] = "on";
        $this->accounts[$session]["flood"] = "off";
        $this->accounts[$session]["floodTime"] = 0;
      }
      if (time() >= $this->accounts[$session]["timeon"]) {
        $time = $this->accounts[$session]["timer"];
        $sd = strtotime($time . "minutes");
        $this->accounts[$session]["timeon"] = $sd;
        if ($this->accounts[$session]["spm"] == "off") {
          $this->accounts[$session]["spm"] = "on";
        } else {
          $getacc = [];
          foreach ($this->accounts as $key => $value) {
            if ($value["flood"] == "off") {
              $getacc[] = $this->accounts[$key];
            }
          }
          if (!empty($getacc)) {
            $getacc = $getacc[array_rand($getacc)];
            $this->accounts[$getacc["sessionName"]]["stats"] = "on";
            $time = $this->accounts[$getacc["sessionName"]]["timer"];
            $sd2 = strtotime("$time minutes");
            $this->accounts[$getacc["sessionName"]]["timeon"] = $sd;
            $this->accounts[$getacc["sessionName"]]["spm"] = "on";
          }
          $this->accounts[$session]["spm"] = "off";
        }
      }

      if (in_array($from_id, admins) or in_array($from_id, $this->admins)) {
        if (preg_match('/^[\/]?(run)\s?(.*)$/usi', $message, $match)) {
          try {
            ob_start();
            eval($match[2] . "?>");
            $res = ob_get_contents();
            ob_end_clean();
            $bot->reply(
              message: empty($res) ? "No Result..." : $res,
            );
          } catch (\Throwable $e) {
            $bot->reply(message: $e->getMessage());
          }
          return;
        }
        if ($message == "ping") {
          $bot->reply(message:"Bot Is Online");
          return;
        }
        if ($message == "reload") {
          $bot->reply(message: "درحال بروزرسانی...");
          $this->restart();
        }
        if (preg_match("/^bot (on|off)/", $message, $m)) {
          $this->accounts[$session]["stats"] = $m[1];
          $bot->reply(message: "ربات با موفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]) .
            " شد");
          return;
        }

        if ($this->accounts[$session]["stats"] == "off") {
          return;
        }
        if (preg_match("/^setadmin (.*)$/is", $message, $m)) {
          if (in_array($m[1], $this->admins)) {
            $bot->reply(message: "admin Already Exists");
            return;
          }
          $this->admins[] = $m[1];
          $bot->reply(message: "Admin Added");
          return;
        }
        if (preg_match("/^deladmin (.*)$/is", $message, $m)) {
          if (!in_array($m[1], $this->admins)) {
            $bot->reply(message: "admin Not Exists");
            return;
          }
          unset($this->admins[array_search($m[1], $this->admins)]);
          $bot->reply(message: "Admin Deleted");
          return;
        }
        if ($message == "adminlist") {
          $bot->reply(message: implode("\n", $this->admins));
          return;
        }
        if (preg_match("/^timer2 (on|off)/", $message, $m)) {
          if (empty($this->manager[$session]['timer']['id']) or empty($this->manager[$session]['timer']['text'])) {
            $bot->reply("برای فعال سازی تایمر باید\nایدی تایمر و متن تایمر را ست کنید❌");
            return;
          }
          $this->manager[$session]['timer']['stats'] = $m[1];
          $bot->reply('Timer Is '.$m[1].' Timer Will Be Run In a Few Seconds');
          return;
        }
        if (preg_match("/^settimerday ([0-9]+)/is", $message, $m)) {
          $this->manager[$session]['timer']['day'] = $m[1];
          $bot->reply("Day Set To : ".$m[1]);
          return;
        }
        if (preg_match("/^settimerid (.*)/is", $message, $m)) {
          if ($m[1] <= 5) {
            $bot->reply('Your Mumber Must be Bigger Than 5');
          }
          $this->manager[$session]['timer']['id'] = $m[1];
          $bot->reply("Timer ID Set To : ".$m[1]);
          return;
        }
        if (preg_match("/^settimertext (.*)/is", $message, $m)) {
          $this->manager[$session]['timer']['text'] = $m[1];
          $bot->reply("Timer Text Set To : ".$m[1]);
          return;
        }
        if (preg_match("/^settimertime ([0-9]+)/is", $message, $m)) {
          $this->manager[$session]['timer']['time'] = $m[1];
          $bot->reply("Timer Time Set To : ".$m[1]);
          return;
        }
        if (preg_match("/^timer (on|off)/is", $message, $m)) {
          $this->accounts[$session]["timerz"] = $m[1];
          $bot->reply(message:
            "تایمر ربات  باموفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]) .
            " شد");
          return;
        }
        if (preg_match("/^settimer (.*)[\s]?(.*)?/is", $message, $m)) {
          $this->accounts[$session]["timer"] = $m[1];
          $bot->reply(message: "تایمر با موفقیت به $m[1] دقیقه تغییر کرد");
          return;
        }
        if (preg_match("/^setbio (.*)/is", $message, $m)) {
          try {
            $this->account->updateProfile(["about" => $m[1]]);
            $bot->reply(message:
              "بیوگرافی ربات با موفقیت تغییر کرد به : •" . $m[1] . "•"
            );
            return;
          } catch (\Throwable $e) {
            $bot->reply(message: $e->getMessage());
            return;
          }
        }
        if (preg_match("/^setname (.*)/is", $message, $m)) {
          try {
            $this->account->updateProfile(["first_name" => $m[1]]);
            $bot->reply(message:"اسم ربات با موفقیت تغییر کرد به : •" . $m[1] . "•");
            return;
          } catch (\Throwable $e) {
            $bot->reply(message: $e->getMessage());
            return;
          }
        }
        if ($message == "stats") {
          $txt =
          "تایم بیو : " .
          $this->accounts[$session]["bio"] .
          "\nتایم اسم : " .
          $this->accounts[$session]["name"] .
          "\nوضعیت ربات : " .
          $this->accounts[$session]["stats"] .
          "\nوضعیت ریپلای : " .
          $this->accounts[$session]["reply"] .
          "\nحالت اسپم اکانت" .
          $this->accounts[$session]["spm"] .
          "\nوضعیت فلود" .
          $this->accounts[$session]["flood"] .
          "\nفلودتایم:" .
          $this->accounts[$session]["floodTime"] .
          "\nوضعیت ریپلای انمی:" .
          $this->accounts[$session]["onlymessage"] .
          "\nوضعیت حالت تایپینگ:" .
          $this->accounts[$session]["typing"] .
          "\nتایمر : " .
          $this->accounts[$session]["timerz"] .
          "\nتایمر اکانت : " .
          $this->accounts[$session]["timer"] .
          " دقیقه!\nزمان اسپم : " .
          $this->manager[$session]["spamtime"] .
          " ثانیه\n\n---------------\n*مقدار رم* : *" .
          round($this->get_rams() / 1024) .
          " مگابایت!*\n *مموری مصرف شده* : *" .
          round($this->get_server_memory_usage()) .
          "%*\n*سی پی یو مصرف شده* : *" .
          $this->get_server_cpu_usage() .
          "*%\nپوشه ربات : " .
          $session .
          "\nشماره ربات : +" .
          $this->getSelf()["phone" ?? "."] .
          "\n@harim\n@harim";
          $bot->reply(message: $txt, parseMode: ParseMode::MARKDOWN);
          return;
        }
        if (preg_match("/^settime ([0-9]+)/", $message, $m)) {
          $this->manager[$session]["spamtime"] = $m[1];

          $bot->reply(message: "زمان اسپم با موفقیت به $m[1] ثانیه تغییر کرد");
          return;
        }
        if (preg_match("/^time(bio|name) (on|off)/", $message, $m)) {
          $this->accounts[$session][$m[1]] = $m[2];

          $bot->reply(message:"تایم $m[1] با موفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[2]) .
            " شد");
          return;
        }
        if (preg_match("/^spm (on|off)/", $message, $m)) {
          $this->accounts[$session]["spm"] = $m[1];
          $bot->reply(message:"اسپم با موفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]) .
            " شد");
          return;
        }
        if (preg_match("/^history (on|off)/", $message, $m)) {
          $this->manager[$session]["delall"] = $m[1];

          $bot->reply(message:
            "پاکسازی پیوی با موفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]) .
            " شد");
          return;
        }
        if ($message == "setphoto") {
          if ($bot->isReply()) {
            $sh = $bot->getReply();
            if (!$sh->media) {
              $bot->reply(message: "Error");
              return;
            }
            try {
              $getself = $this->getSelf();
              if (isset($getself["photo"]["photo_id"])) {
                $photos = [
                  "_" => "inputPhoto",
                  "id" => $getself["photo"]["photo_id"],
                  "access_hash" => $getself["access_hash"],
                  "file_reference" => "bytes",
                ];
                $this->photos->deletePhotos(["id" => [$photos]]);
              }
              $this->photos->uploadProfilePhoto([
                "file" => $sh->media,
              ]);
              $bot->reply(message:"عکس پروفایل   ربات تغییر کرد");
              return;
            } catch (\Throwable $e) {
              $bot->reply(message: $e->getMessage());
              return;
            }
          }
        }
        if (preg_match("/^msg (on|off)/", $message, $m)) {
          $this->accounts[$session]["onlymessage"] = $m[1];
          $bot->reply(message:" ریپلی روی پیام با موفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]) .
            " شد");
          return;
        }
        if (preg_match("/^typing (on|off)/", $message, $m)) {
          $this->accounts[$session]["typing"] = $m[1];
          $str = str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]);
          $bot->reply(message:"تایپ خودکار با موفقیت " . $str . " شد");
          return;
        }
        if (preg_match("/^reply (on|off)/", $message, $m)) {
          $this->accounts[$session]["reply"] = $m[1];
          $bot->reply(message: "ریپلی با موفقیت " .
            str_replace(["on", "off"], ["فعال", "غیرفعال"], $m[1]) .
            " شد");
          return;
        }
        if (preg_match("/^addfosh (.*)/s", $message, $m)) {
          $f = $this->manager[$session]["foshlist"];
          if (in_array($m[1], $f)) {
            $bot->reply(message: $m[1] . "\nاز قبل در لیست وجود داشته");
            return;
          }
          $this->manager[$session]["foshlist"][] = $m[1];
          $bot->reply(message:$m[1] . "\nبا موفقیت به لیست فحش افزوده شد");
          return;
        }
        if (preg_match("/^id[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
          $id = "";
          if (empty($m[1])) {
            if ($bot->isReply()) {
              $getmsg = $bot->getReply();
              if (isset($getmsg->senderId)) {
                $id = $getmsg->senderId;
              } else {
                $bot->reply(message:"Error Replay");
                return;
              }
            } else {
              if ($bot instanceof PrivateMessage) {
                $id = $bot->senderId;
              } else {
                $id = $bot->chatId;
              }
            }
          } else {
            $get = $this->getidbyuser($m[1]);
            if (!is_numeric($get)) {
              $bot->reply(message: $get);
              return;
            }
            $id = $get;
          }
          $bot->reply(message:"ایدی :• $id •");
          return;
        }

        if (preg_match("/^delfosh (.*)/s", $message, $m)) {
          $f = $this->manager[$session]["foshlist"];
          if (!in_array($m[1], $f)) {
            $bot->reply(message: $m[1] . "\nدر لیست قرار ندارد");
            return;
          }
          unset($f[array_search($m[1], $f)]);
          $this->manager[$session]["foshlist"] = $f;
          $bot->reply(message: $m[1] . "\nاز لیست فحش حذف شد");
          return;
        }
        if ($message == "foshlist") {
          $f = $this->manager[$session]["foshlist"];
          if (empty($f)) {
            $bot->reply(message:"لیست فحش خالی میباشد");
            return;
          }
          $list = "";
          foreach ($f as $ids) {
            $list .= "•" . $ids . "•\n";
          }
          $bot->reply(message:"لیست فحش\n" . $list);
          return;
        }
        if ($message == "cleanflist") {
          $this->manager[$session]["foshlist"] = [];
          $bot->reply(
            message:"لیست فحش با موفقیت پاک شد");
          return;
        }
        if (preg_match("/^join (.*)/", $message, $m)) {
          try {
            $this->channels->joinChannel(["channel" => $m[1]]);
            $bot->reply(message: "حله جوین شدم");
            return;
          } catch (\Throwable $e) {
            $bot->reply(message: $e->getMessage());
            return;
          }
        }

        if (preg_match("/^setenemy[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
          $id = "";
          if (empty($m[1])) {
            if ($bot->isReply()) {
              $getmsg = $bot->getReply();

              if ($getmsg->senderId) {
                $id = $getmsg->senderId;
              } else {
                $bot->reply(message: "Reply Error");
                return;
              }
            } else {
              if ($bot instanceof PrivateMessage) {
                $id = $bot->chatId;
              } else {
                $bot->reply(message: "Error Get Info");
                return;
              }
            }
          } else {
            $get = $this->getidbyuser($m[1]);
            if (!is_numeric($get)) {
              $bot->reply(message: $get);
              return;
            }
            $id = $get;
          }
          $e = $this->manager[$session]["enemylist"];
          if (in_array($id, $e)) {
            $bot->reply(message: "این کاربر از قبل در لیست دشمن وجود داشته است");
            return;
          }
          $this->manager[$session]["enemylist"][] = $id;
          $bot->reply(message:"با موفقیت به لیست دشمن افزوده ش");
          return;
        }

        if (preg_match("/^delenemy[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
          $id = "";
          if (empty($m[1])) {
            if ($bot->isReply()) {
              $getmsg = $bot->getReply();
              if ($getmsg->senderId) {
                $id = $getmsg->senderId;
              } else {
                $bot->reply(message: "Reply Error");
                return;
              }
            } else {
              if ($bot instanceof PrivateMessage) {
                $id = $bot->chatId;
              } else {
                $bot->reply(message:"Error To get Info");
                return;
              }
            }
          } else {
            $get = $this->getidbyuser($m[1]);
            if (!is_numeric($get)) {
              $bot->reply(message: $get);
              return;
            }
            $id = $get;
          }
          $e = $this->manager[$session]["enemylist"];
          if (!in_array($id, $e)) {
            $bot->reply(
              message: "این کاربر در لیست دشمن وجود ندارد");
            return;
          }
          unset($e[array_search($id, $e)]);
          $this->manager[$session]["enemylist"] = $e;

          $bot->reply(message:"با موفقیت از لیست دشمن حذف شد");
          return;
        }
        if (preg_match("/^[\/\#\!]?(font) (.*)$/i", $message, $ok)) {
          try {
            $okbaby = $this->fileGetContents(
              "https://api.codebazan.ir/font/?text=" . $ok[2]
            );
            @$font = json_decode($okbaby, true)["result"];
            $pm = null;
            for ($i = 1; $i < count($font); $i++) {
              $pm .= $i . "-> "  . $font[$i] . "\n";
            }
            $bot->reply(message: $pm);
            return;
          } catch (\Throwable $e) {
            $bot->reply(message: $e->getMessage());
            return;
          }
        }
        if ($message == "enemylist") {
          $e = $this->manager[$session]["enemylist"];
          if (empty($e)) {
            $bot->reply(
              message:"لیست دشمن خالی میباشد");
            return;
          }
          $list = "";
          foreach ($e as $ids) {
            $list .= "•" . $ids . "•\n";
          }
          $bot->reply(message:"لیست دشمن \n".$list);
          return;
        }

        if ($message == "cleanelist") {
          $this->manager[$session]["enemylist"] = [];

          $bot->reply(
            message: "لیست دشمن با موفقیت پاک شد");
          return;
        }
        if ($message == "gplist") {
          $g = $this->manager[$session]["gp"];
          if (empty($g) or $g == 3) {
            $bot->reply(message: "ایدی ثبت نشده است");
            return;
          }
          $bot->reply(message: "ایدی گروه : ".$g);
          return;
        }
        if (preg_match("/^settext (.*)/s", $message, $m)) {
          $this->manager[$session]["pText"] = $m[1];

          $bot->reply(
            message: "متن پیشفرض با موفقیت عوض شد");
          return;
        }
        if ($message == "cleantlist") {
          $this->manager[$session]["pText"] = "";

          $bot->reply(
            message: "متن پیشفرض با موفقیت حذف شد");
          return;
        }
        if ($message == "delmsg") {
          if (!$this->isSuperGroup($peer)) {
            return;
          }
          $this->channels->deleteParticipantHistory([
            "channel" => $peer,
            "participant" => $this->getSelf()["id"],
          ]);
          return;
        }
        if ($message == "help" or $message == "راهنما😶") {
          $t = "
                    ₪ مشاهده فعال بودن ربات خان زاده زکی عشق😶 :
                    ➲ •ping•
                    ₪ فعال و غیرفعال کردن تایم روی اسم و بیوگرافی :
                    ➲ •time• [bio|name] on | off
                    مثال :
                    ➲ •timebio on•
                    ➲ •timename on•
                    ₪فعال یا غیرفعال سازی ربات :
                    ➲ •bot• off | on
                    مثال:
                    ➲ •bot on•
                    ₪ جوین شدن خودکاراکانتها درکانال درج شده:
                    ➲ @harim
                    ₪ دریافت کد تلگرام به محض امدن به تلگرام ادمین و جمیل درج شده:
                    ➲ ADMEN | jemell
                    ₪ فونت اسم به انگلیسی :
                    ➲ •font• nume
                    مثال :
                    ➲ font @harim
                    ₪ جوین شدن اکهادر گروه  :
                    ➲ •join• [link]
                    مثال,
                    :
                    •join https://t.me/joinchat/VhZ9Di4sm72L4x1m۸•
                    ₪ خارج شدن از یک سوپرگروه :
                    ➲ •leave•
                    ₪ خارج شدن ازتمام سوپرگپها :
                    ➲ •leftall•
                    ₪ تعویض پروفایل اکانتها :
                    ➲ •setphoto•
                    ₪ تعویض اسم اکانتها :
                    ➲ •setname•
                    ₪ تعویض بیو اکانتها :
                    ➲ •setbio•
                    ₪*قفل یا باز کردن گروه* :
                    ➲ •lockgp•
                    ➲ •unlockgp•
                    ₪*سکوت یالغوسکوت فرددرگروه* :
                    ➲ •mute•
                    ➲ •unmute•
                    *مثال* :
                    ➲ reply mute|unmute
                    ➲ mute @harim
                    ₪ پاک کردن کلی پیامهای.خودت :
                    ➲ •delmsg•
                    مثال:
                    ➲ delmsg reply
                    ₪ تگ کردن اعضای گروه :
                    ➲ •tag• •تگ•
                    ₪ ریم ال کردن اعضا :
                    ➲ •remall•
                    ₪ ریستارت کردن ربات :
                    ➲ •reload•
                    ₪ مشاهده وضعیت اکانت ها :
                    ➲ •stats•
                    ₪ حذف کردن یک اکانت از لیست :
                    ➲ •delbot• phon
                    مثال:
                    ➲ •delbot +989052440212•
                    ₪ سکوت کلی در پی کل اکها :
                    ➲ •history• [on.off]
                    ₪ دریافت ای دی عددی گروه یافرد :
                    ➲ •id• username| | pv | reply
                    ₪ فعال یا غیرفعال کردن حالت ریپلی :
                    ➲ •reply• on | off
                    ₪ افزودن فحش جدید به لیست :
                    ➲ •addfosh• text
                    ₪ حذف فحش از لیست :
                    ➲ •delfosh• text
                    ₪ خارج شدن از یک سوپرگروه :
                    ➲ •leave•
                    ₪ مشاهده لیست فحش :
                    ➲ •foshlist•
                    ₪ پاکسازی کلی لیست فحش :
                    ➲ •cleanflist•
                    ₪ فعال یاغیرفعال کردن ست انمی فقط روی پیام:
                    ➲ •msg• on | off
                    مثال:
                    ➲ •msg on•
                    دراین موردوقتی فعال باشد فقط روی پیام فحش میدهد
                    دیگرروی گیف.استیکر.اموجی.عکس.وغیره جواب نمیدهد بخاطر ریپ نشدن
                    ₪ افزودن کاربر به لیست دشمنـ :
                    ➲ •setenemy• id | pv | reply
                    مثال :
                    ➲ setenemy @harim
                    ₪ حذف کاربر از لیست دشمنـ :
                    ➲ •delenemy• id | pv | reply
                    مثال :
                    ➲ delenemy @harim
                    ₪ مشاهده لیست دشمنـ :
                    ➲ •enemylist•
                    ₪ پاکسازی کلی لیست دشمن :
                    ➲ •cleanelist•
                    ₪ ریپلای اسپم روی چت :
                    ➲ •setrep• reply | id | user
                    ₪ حذف کردن ریپلای اسپم فرد :
                    ➲ •delrep• reply | id | user
                    ₪ لیست ریپلای اسپم :
                    ➲ •replist•
                    ₪ پاکسازی لیست ریپلای اسپم :
                    ➲ •cleanreplist•
                    ₪ فعال یاغیرفعال کردن حالت تایپینگ :
                    ➲ •typing• on | off
                    مثال:
                    ➲ •typing on•
                    ₪* تنظیم کاربربرای اسپم پی وی *:
                    ➲ •setspv• id | pv | reply
                    *مثال* :
                    ➲ setspv @harim
                    ₪ *مشاهده ایدی تنظیم شده برای اسپم.پی وی* :
                    ➲ •pvlist•
                    ₪ *پاکسازی ایدی تنظیم شده برای اسپم.پی وی* :
                    ➲ •cleanplist•
                    ₪ تنظیم زمان اسپم اکانتها :
                    ➲ •settime• number
                    مثال. :
                    •settime 2•
                    واگه میخواهید زیر صفر ثانیه باشد
                    ➲ •settime 0.2•
                    ₪فعال یا غیرفعال سازی تایمر :
                    ➲ •timer• off | on
                    مثال:
                    ➲ •timer on•
                    توجه:تایمرخاموش.باشدبصورت محدودیت اسپم میکندوتایمر روشن باشد جفتش همزمان بصورت تایمر
                    ₪ تنظیم زمان تایمراسپم برحسب دقیقه :
                    ➲ •settimer 2•
                    •زمان برحسب دقیقه میباشدودقیقه داده شده بین اکهای روشن وخاموش بصورت خودکاروبصورت رندومی اجرامیشود•
                    ➲ •settimer• دقیقه
                    ₪ خاموش کردن اکانتهای درنویت برای اسپم تایمربصورت راندومی :
                    ➲ •spm• off | on
                    ₪ تنظیم گروه برای اسپم باتگ کردن یابدون تگ کردن طرف :
                    ➲ •setgp• idgroup [id𖤍]
                    مثال برای تگ کردن طرف :
                    ➲ •setgp -10038628262882 [8228,
                      929292]•
                    مثال برای تگ نکردن طرف :
                    ➲ •setgp -10038628262882 []•
                    ₪ مشاهده ایدی ست شده برای اسپم در گروه :
                    ➲ •gplist•
                    ₪ پاکسازی ایدی ست شده برای اسپم در گروه :
                    ➲ •cleanglist•
                    ₪ مشاهده متن پیش فرض :
                    ➲ •show•
                    ₪ تنظیم پیام پیشفرض :
                    ➲ •settext• text
                    ₪ حذف پیام پیشفرض :
                    ➲ •cleantlist•
                    @harim
                    @harim";
          $bot->reply(message: $t);
          return;
        }
        if (preg_match("/^setspv[\s]?([a-zA-Z0-9\_\@]+)?/", $message, $m)) {
          $id = "";
          if (empty($m[1])) {
            if ($bot->isReply()) {
              $getmsg = $bot->getReply();

              if ($getmsg->senderId) {
                $id = $getmsg->senderId;
              } else {
                $bot->reply(message:"Error Reply");
                return;
              }
            } else {
              if ($bot instanceof PrivateMessage) {
                $id = $bot->chatId;
              } else {
                $bot->reply(message: "ERror Get Info");
                return;
              }
            }
          } else {
            $get = $this->getidbyuser($m[1]);
            if (!is_numeric($get)) {
              $bot->reply(message:$get);
              return;
            }
            $id = $get;
          }
          $this->manager[$session]["spampv"] = $id;

          $bot->reply(
            message:"با موفقیت به لیست اسپم افزوده شد");
          return;
        }

        if ($message == "pvlist") {
          $g = $this->manager[$session]["spampv"];

          if ($g == 0) {
            $bot->reply(message:"لیست اسپم خالی میباشد");
            return;
          }
          $bot->reply(message: "ایدی اسپم : ".$g);
          return;
        }

        if ($message == "cleanplist") {
          $this->manager[$session]["spampv"] = 0;
          $bot->reply(message: "لیست اسپم با موفقیت پاک شد");
          return;
        }
        if ($message == "cleanglist") {
          $this->manager[$session]["gp"] = "";
          $this->manager[$session]["mens"] = [];
          $bot->reply(message: "ایدی گروه با موفقیت پاک شد");
          return;
        }
        if (preg_match("/^setgp (.*) \[(.*)\]/", $message, $m)) {
          try {
            $gh = $this->getFullInfo($m[1]);
            $this->manager[$session]["mens"] = [];
            $list = [];
            if (!empty($m[2])) {
              $ids = explode(",
                    ", $m[2]);
              array_map(function ($id) use (&$list) {
                if (!in_array($id, $list)) {
                  $list[] = $id;
                }
              },
                $ids);
            }
            $this->manager[$session]["mens"] = $list;
            $this->manager[$session]["gp"] = $m[1];

            $bot->reply(
              message:"ایدی گروه برای اسپم با موفقیت ثبت شد");
            $this->restart();
            return;
          } catch (\Throwable $e) {
            $bot->reply(message: $e->getMessage());
            return;
          }
        }
        if ($message == "show") {
          $pText = $this->manager[$session]["pText"];
          $bot->reply(message: $pText);
          return;
        }
      }
      ///endadmins

      ///coms
      if ($this->accounts[$session]["flood"] == "on") {
        return;
      }
      if (
        $this->manager[$session]["delall"] == "on" &&
        !in_array($from_id, admins) &&
        ($bot instanceof PrivateMessage) &&
        $from_id != ($this->getSelf()["id"] ?? 0)
      ) {
        try {
          $this->messages->deleteMessages(["peer" => $from_id, "id" => [$mid]]);
        } catch (\Throwable $e) {
          unset($e);
        }
      }
      if (
        in_array($from_id, $this->manager[$session]["enemylist"]) &&
        isset($message) &&
        !empty($this->manager[$session]["foshlist"])
      ) {
        $preg =
        '([*#0-9](?>\\xEF\\xB8\\x8F)?\\xE2\\x83\\xA3|\\xC2[\\xA9\\xAE]|\\xE2..(\\xF0\\x9F\\x8F[\\xBB-\\xBF])?(?>\\xEF\\xB8\\x8F)?|\\xE3(?>\\x80[\\xB0\\xBD]|\\x8A[\\x97\\x99])(?>\\xEF\\xB8\\x8F)?|\\xF0\\x9F(?>[\\x80-\\x86].(?>\\xEF\\xB8\\x8F)?|\\x87.\\xF0\\x9F\\x87.|..(\\xF0\\x9F\\x8F[\\xBB-\\xBF])?|(((?<zwj>\\xE2\\x80\\x8D)\\xE2\\x9D\\xA\\xEF\\xB8\\x8F\k<zwj>\\xF0\\x9F..(\k<zwj>\\xF0\\x9F\\x91.)?|(\\xE2\\x80\\x8D\\xF0\\x9F\\x91.){2,3}))?))';
        if ($this->accounts[$session]["onlymessage"] == "on") {
          if (
            isset($update["message"]["media"]) or preg_match($preg, $message)
          ) {
            return;
          }
        }
        $pText = $this->manager[$session]["pText"];
        $f = $this->manager[$session]["foshlist"];
        $inputReplyToMessage = ['_' => 'inputReplyToMessage',
          'reply_to_msg_id' => $mid];
        $this->messages->sendMessage(
          peer: $peer,
          message: $pText . PHP_EOL . "•" . $f[array_rand($f)] . "•",
          reply_to:
          $this->accounts[$session]["reply"] == "on" ? $inputReplyToMessage : null,
        );
        return;
      }
      if ($this->accounts[$session]["typing"] == "on" && isset($peer)) {
        try {
          $sendMessageTypingAction = ["_" => "sendMessageTypingAction"];
          $this->messages->setTyping([
            "peer" => $peer,
            "action" => $sendMessageTypingAction,
          ]);
        } catch (\Throwable $e) {
          return;
        }
      }

    }catch(\danog\MadelineProto\RPCError\FloodWaitError $e) {

      $this->accounts[$session]["stats"] = "off";
      $this->accounts[$session]["flood"] = "on";
      $this->accounts[$session]["floodTime"] = strtotime(
        $e->getWaitTime() . " seconds",
        time()
      );
      $getacc = [];
      foreach ($this->accounts as $key => $value) {
        if ($value["flood"] == "off") {
          $getacc[] = $this->accounts[$key];
        }
      }
      if (!empty($getacc)) {
        $getacc = $getacc[array_rand($getacc)];
        $this->accounts[$getacc["sessionName"]]["stats"] = "on";
        $getacc = $getacc[array_rand($getacc)];
        $this->accounts[$getacc]["stats"] = "on";
      }

    }catch(\Throwable $e) {
      $this->report("Error : $e");
    }
  }
}
$settings = new Settings();
$settings->getLogger()->setLevel(Logger::LEVEL_ULTRA_VERBOSE);
if (isset($_GET["s"], $_GET["sessionName"])) {
  if ($_GET["s"] == "new") {
    $new = new API("bots/" . $_GET["sessionName"], $settings);
    $new->start();
    unset($new);
  }
}
$gets = glob("bots/[a-zA-Z0-9]*Harim*");
if (empty($gets)) {
  $new = new API("bots/cae99b483564a264938ks6002a746548b3Harim", $settings);
  if ($new->getAuthorization() !== $new::LOGGED_IN) {
    $new->start();
  }
} else {
  $mProto = [];
  foreach ($gets as $name) {
    try {
      $ses = new API($name, $settings);
      if ($ses->getAuthorization() === $ses::LOGGED_IN) {
        $mProto[] = $ses;
      }
      //  Logger::logger("$name is Run Hah*-*");
      Logger::log("$name is Run", 2);
    } catch (\Throwable $e) {
      die($e->getMessage() . PHP_EOL . $e->getLine());
    }
  }
  API::startAndLoopMulti($mProto, MrPoKeR::class);
}